﻿using System;
using System.Collections.Generic;
using System.Linq;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class ServiceEpisodeManager
    {
       public static void UpdateRegistrantWithServiceEpisodes(BprInfo bprInfo, REGISTRANT registrant)
        {
            REGISTRANT_SERVICE_EPISODE serviceEpisode = new REGISTRANT_SERVICE_EPISODE();
            foreach (BprServiceEpisode serviceEpisodeItem in bprInfo.serviceEpisodes)
            {
                serviceEpisode = new REGISTRANT_SERVICE_EPISODE();
                serviceEpisode.REGISTRANT_ID = registrant.REGISTRANT_ID;
                serviceEpisode.SERVICE_EPISODE_TERMINATION_REASON = serviceEpisodeItem.serviceEpisodeTerminationReason;
                if (!string.IsNullOrEmpty(serviceEpisodeItem.serviceEpisodeStartDate))
                {
                    serviceEpisode.SERVICE_EPISODE_START_DATE = DateTimeOffset.Parse(serviceEpisodeItem.serviceEpisodeStartDate).UtcDateTime;
                }
                if (!string.IsNullOrEmpty(serviceEpisodeItem.serviceEpisodeEndDate))
                {
                    serviceEpisode.SERVICE_EPISODE_END_DATE = DateTimeOffset.Parse(serviceEpisodeItem.serviceEpisodeEndDate).UtcDateTime;
                }
                int branchOfServiceId = AHOBPRJsonDataManager.GetStdBranchOfServiceId(serviceEpisodeItem.branchOfService);
                if (branchOfServiceId > 0)
                {
                    serviceEpisode.STD_BRANCH_OF_SERVICE_ID = branchOfServiceId;
                }
                serviceEpisode.BRANCH_OF_SERVICE_TEXT = serviceEpisodeItem.branchOfService;

                registrant.REGISTRANT_SERVICE_EPISODEs.Add(serviceEpisode);
                registrant.REGISTRANT_SERVICE_EPISODEs.Last().SetAsInsertOnSubmit();
            }
        }

    }
}
